"use client";
import Link from "next/link";
import { Menu } from "lucide-react";
import { Button } from "@/components/ui/button";
import {
  Sheet,
  SheetContent,
  SheetDescription,
  SheetTitle,
  SheetTrigger,
} from "@/components/ui/sheet";
import UpgradeMessage from "@/components/upgrade/upgrade-message";
import { menu } from "@/constants/menu";
import { usePathname } from "next/navigation";
import { memo } from "react";
import LogoDark from "@/components/shared/logo-dark";
import { blinkConfig } from "@/config/blink-config";

function MenuItem({ item, pathName }) {
  const isActive = pathName === item?.href;
  return (
    <Link
      href={item?.href}
      className={`flex items-center gap-3 rounded-lg px-3 py-2 transition-all hover:text-primary ${
        isActive
          ? "border border-solid border-primary rounded-lg bg-muted text-primary"
          : "border border-transparent"
      }`}
    >
      {item?.icon}
      {item?.title}
    </Link>
  );
}

const MobileSidebar = memo(function MobileSidebarComponent() {
  const pathName = usePathname();
  return (
    <Sheet>
      <SheetTrigger asChild>
        <Button variant="outline" size="icon" className="shrink-0 md:hidden">
          <Menu className="h-5 w-5" />
          <span className="sr-only">Toggle navigation menu</span>
        </Button>
      </SheetTrigger>
      <SheetContent side="left" className="flex flex-col">
        <SheetDescription />
        <nav className="grid gap-2 text-sm font-medium">
          <div className="flex items-center gap-2">
            <div className="w-full h-full max-w-6 my-4">
              <LogoDark />
            </div>
            <SheetTitle>{blinkConfig?.title}</SheetTitle>
          </div>
          {menu.map((item, index) => (
            <MenuItem key={index} item={item} pathName={pathName} />
          ))}
        </nav>
        <div className="mt-auto">
          <UpgradeMessage />
        </div>
      </SheetContent>
    </Sheet>
  );
});

export default MobileSidebar;
